import { Router } from 'express';
import { shoppingListController } from './controller';
import { authenticateUser, requireVendor } from '@/middlewares/auth';
import { vendorService } from '@/modules/vendors/service';

const router = Router();

// Attach vendor to req for downstream use
async function attachVendor(req: any, res: any, next: any) {
  if (req.user) {
    const { data: vendor } = await vendorService.getVendorByUserId(req.user.id);
    req.vendor = vendor || null;
  }
  next();
}

// Create shopping list
router.post('/shopping-lists', authenticateUser, requireVendor, attachVendor, shoppingListController.createShoppingList);
// Match sellers for a shopping list
router.get('/shopping-lists/:id/match-sellers', authenticateUser, requireVendor, attachVendor, shoppingListController.matchSellers);
// Create order from selected seller
router.post('/orders', authenticateUser, requireVendor, attachVendor, shoppingListController.createOrder);
// Get my orders
router.get('/orders', authenticateUser, requireVendor, attachVendor, shoppingListController.getOrders);
// Update order status
router.patch('/orders/:id', authenticateUser, requireVendor, attachVendor, shoppingListController.updateOrderStatus);

export default router; 